import QtQuick 2.2
import QtQuick.Controls.Styles 1.3
import QtGraphicalEffects 1.0
import QtQuick.Controls 1.3

import wesual.Controls 1.0

Item {
    id : calendar

    onSelectedDateChanged : {
        if (isNaN(selectedDate.getTime()))
            selectedDate = new Date();
    }

    property alias  selectedDate : cal.selectedDate
    property alias  buttonText   : today.text
    property string pickerText   : ""
    property alias  minimumDate  : cal.minimumDate
    property alias  maximumDate  : cal.maximumDate

    implicitWidth  : calendarBorder.width
    implicitHeight : calendarBorder.height + today.height

    signal clicked(date selectedDate)

    QtObject {
        id : p_

        readonly property int   iconWidth    : 4
        readonly property int   iconHeight   : 8
        readonly property int   offsetLeft   : 2
        readonly property int   offsetRight  : 3
        readonly property int   offsetTop    : 1
        readonly property int   offsetBottom : 13

    }

    MouseArea {
        // prevent clicking "through" popup
        anchors.fill    : parent
        acceptedButtons : Qt.AllButtons
        onClicked       : {}
    }

    Rectangle {
        id : calendarBorder

        width  : cal.width  + p_.offsetLeft + p_.offsetRight
        height : cal.height + p_.offsetTop  + p_.offsetBottom
        border.width : 1
        border.color : UI.color(UI.PrimaryControlBorder)

        Calendar {
            id : cal

            width : 235
            height : 184
            weekNumbersVisible : true
            frameVisible : false
            anchors.verticalCenter: parent.verticalCenter
            anchors.horizontalCenter: parent.horizontalCenter
            selectedDate : new Date()

            style : CalendarStyle {
                dayDelegate : dayDel
                dayOfWeekDelegate : dayOfWeekDel
                weekNumberDelegate : weekNumberDel
                gridVisible : false
                gridColor : "transparent"
                navigationBar : navigationDel
            }

            onPressed : calendar.clicked(date);
        }
    }
    Rectangle {
        anchors.top : calendarBorder.bottom
        anchors.topMargin : -1

        width : calendarBorder.width
        height : 38
        border.width : 1
        border.color : UI.color(UI.PrimaryControlBorder)

        PushButton {
            id : today

            text : qsTrId("8298533db336ff8c")
            isPrimary : false
            anchors.verticalCenter   : parent.verticalCenter
            anchors.horizontalCenter : parent.horizontalCenter
            enabled : calendar.enabled

            onClicked : {
                cal.selectedDate = new Date();
                calendar.clicked(cal.selectedDate);
            }
        }
    }

    Component {
        id : navigationDel

        Item {
            height : 24
            width : parent.width

            Rectangle {
                height : 1
                width : parent.width + p_.offsetLeft + p_.offsetRight

                anchors.top  : navigation.bottom
                anchors.left : parent.left
                anchors.leftMargin : -p_.offsetLeft
                color : UI.color(UI.PrimaryControlBorder)
            }

            Row {
                id : navigation

                anchors.fill : parent
                anchors.leftMargin  : -p_.offsetLeft + 1
                anchors.rightMargin : -p_.offsetRight + 1
                anchors.topMargin   : -p_.offsetTop - 5

                Rectangle {
                    width  : 18
                    height : parent.height

                    color : {
                        if (leftArrow.pressed) {
                            return UI.color(UI.PrimaryPress);
                        } else if (leftArrow.containsMouse) {
                            return UI.color(UI.PrimaryHover);
                        } else {
                            return UI.color(UI.PrimaryBase);
                        }
                    }
                    ColorizedImage {
                        id : iconLeft

                        anchors.verticalCenter   : parent.verticalCenter
                        anchors.horizontalCenter : parent.horizontalCenter

                        width  : p_.iconWidth
                        height : p_.iconHeight

                        sourceSize {
                            width  : p_.iconWidth
                            height : p_.iconHeight
                        }
                        source : "qrc:/controls/icons/calendar-left.png"
                        color : leftArrow.pressed ?
                                UI.color(UI.PrimaryBase) :
                                UI.color(UI.CalendarNavIcon)
                    }
                    MouseArea {
                        id : leftArrow
                        anchors.fill : parent
                        onClicked : cal.showPreviousMonth()
                        hoverEnabled : true
                    }
                }
                Rectangle {
                    width  : parent.width - 36
                    height : parent.height
                    color  : UI.color(UI.PrimaryBase)

                    Text {
                        anchors.horizontalCenter: parent.horizontalCenter
                        anchors.verticalCenter :  parent.verticalCenter
                        text : styleData.title
                        font {
                            family : UI.fontFamily(UI.PrimaryFont)
                            weight : UI.fontWeight(UI.PrimaryFont)
                            pixelSize : 14
                            capitalization : Font.AllUppercase
                        }
                    }
                }
                Rectangle {
                    width  : 18
                    height : parent.height
                    color : {
                        if (rightArrow.pressed) {
                            return UI.color(UI.PrimaryPress);
                        } else if (rightArrow.containsMouse) {
                            return UI.color(UI.PrimaryHover);
                        } else {
                            return UI.color(UI.PrimaryBase);
                        }
                    }

                    ColorizedImage {
                        id : iconRight
                        anchors.verticalCenter   : parent.verticalCenter
                        anchors.horizontalCenter : parent.horizontalCenter

                        width  : p_.iconWidth
                        height : p_.iconHeight

                        sourceSize {
                            width  : p_.iconWidth
                            height : p_.iconHeight
                        }
                        source : "qrc:/controls/icons/calendar-right.png"
                        color : rightArrow.pressed ?
                                UI.color(UI.PrimaryBase) :
                                UI.color(UI.CalendarNavIcon)
                    }
                    MouseArea {
                        id : rightArrow

                        anchors.fill : parent
                        onClicked    : cal.showNextMonth()
                        hoverEnabled : true
                    }
                }
            }
        }
    }

    Component {
        id : dayDel

        Rectangle {
            id : dayRect

            height : 22
            width : 30

            color : UI.color(UI.PrimaryBase)

            enabled : styleData.valid

            states : [
                State {
                    name : "selected"
                    when : enabled && !(pickerText === "") && styleData.selected

                    PropertyChanges {
                        target : dayRect
                        color : UI.color(UI.PrimaryPress)
                    }
                },
                State {
                    name : "hovered"
                    when : enabled && styleData.hovered

                    PropertyChanges {
                        target : dayRect
                        color  : UI.color(UI.PrimaryHover)
                    }
                }
            ]

            border.width : styleData.today ? 1 : 0
            border.color : styleData.today ?
                               UI.color(UI.PrimaryPress) : "transparent"

            Text {
                anchors.fill : parent
                text : styleData.date.getDate()
                font {
                    family : UI.fontFamily(UI.PrimaryFont)
                    weight : UI.fontWeight(UI.PrimaryFont)
                    pixelSize : 13
                }

                verticalAlignment : Text.AlignVCenter
                horizontalAlignment : Text.AlignHCenter
                color   : dayRect.state === "selected" ?
                          UI.color(UI.SelectedTextColor) :
                          UI.color(UI.PrimaryTextColor)
                opacity : {
                    if (!enabled)
                        return 0.3;

                    if (styleData.selected)
                        return 1.0
                    else if (styleData.hovered)
                        return 1.0
                    else {
                        if (styleData.visibleMonth)
                            return 1.0
                        else
                            return 1.0
                    }
                }
            }

            MouseArea {
                anchors.fill : parent
                cursorShape  : enabled ? Qt.PointingHandCursor : Qt.ArrowCursor
                propagateComposedEvents : true
                onPressed : mouse.accepted = false
            }
        }
    }

    Component {
        id : dayOfWeekDel

        Rectangle {
            width : 30
            height : 27
            color : "transparent"

            QtObject {
                id : p_

                readonly property var days : [ qsTrId("3d3055c923676e4e"),
                                               qsTrId("5ae9acf373085f09"),
                                               qsTrId("e5fc9e03383918bc"),
                                               qsTrId("2d5da3b04794ad2e"),
                                               qsTrId("6986a1eba0a82a2e"),
                                               qsTrId("365a9254a845e867"),
                                               qsTrId("efae8815e7e77e11") ]
            }

            Text {
                anchors.fill : parent
                anchors.leftMargin : 3
                anchors.bottomMargin : 2
                text : p_.days[styleData.dayOfWeek]
                font {
                    family : UI.fontFamily(UI.SecondaryFont)
                    weight : UI.fontWeight(UI.SecondaryFont)
                    pixelSize : 13
                }
                color : UI.color(UI.SecondaryTextColor)
                verticalAlignment : Text.AlignBottom
                horizontalAlignment : Text.AlignHCenter
            }
        }
    }

    Component {
        id : weekNumberDel

        Rectangle {
            width : 23
            height : 22
            color : "transparent"
            Text {
                text : styleData.weekNumber
                font {
                    family : UI.fontFamily(UI.SecondaryFont)
                    weight : UI.fontWeight(UI.SecondaryFont)
                    pixelSize : 10
                }
                color : UI.color(UI.SecondaryTextColor)
                anchors.bottom   : parent.bottom
                anchors.bottomMargin: 4
                anchors.horizontalCenter : parent.horizontalCenter
            }
        }
    }
}
